#include <windows.h>
#include <commdlg.h>
#include <dos.h>
#include <stdio.h>
#include <io.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <math.h>
#include <share.h>
#include <dir.h>
#include <stat.h>

typedef unsigned short ushort;
typedef unsigned long  ulong;
typedef unsigned char  uchar;
typedef unsigned int   uint;

uchar man[1024];

int OPEN(uchar *nume,int mod)
{
   int i;
   if(mod==FA_ARCH) i=open(nume,O_CREAT|O_BINARY|O_TRUNC|O_RDWR,S_IWRITE|S_IREAD);
   else i=open(nume,mod);
   return i;
}

int Open(uchar *path,uchar *nume,int mod)
{
   int i,lg_path;
   lg_path=strlen(path);
   sprintf(path+lg_path,"%s",nume);
   if(mod==FA_ARCH)
   {
      i=open(path,O_CREAT|O_BINARY|O_TRUNC|O_RDWR,S_IWRITE|S_IREAD);
      close(i);
      i=sopen(path,O_BINARY|O_RDWR,SH_DENYNONE);
   }
   else i=sopen(path,mod,SH_DENYNONE);
   path[lg_path]='\0';
   return i;
}

void LSEEK(int nf,long pozitia,int mod)
{
   if(lseek(nf,pozitia,mod)<0)
   {
      printf("\nEROARE POZITIONARE fisier.");
      exit(0);
   }
}

void READF(int nf,void *art,ulong RCS)
{
   if(read(nf,art,(short)RCS)!=RCS)
   {
      printf("\nEROARE CITIRE fisier.");
      exit(0);
   }
}

void WRITEF(int nf,void *art,ulong RCS)
{
   if(write(nf,art,(short)RCS)!=RCS)
   {
      printf("\nEROARE de SCRIERE pe DISC sau DISC PLIN\n");
      exit(0);
   }
}

void CLOSE(int nf)
{
   if(close(nf))
   {
      printf("\nInchidere fisier imposibila.");
      exit(0);
   }
}

#define STOP_PAG   1
#define ORIENTARE  2
#define LISTARE    3
#define TERMINARE  4
#define ALBASTRU   5
#define ROSU       6
#define VERDE      7
#define NEGRU      8
#define STANGA     9
#define DREAPTA   10
#define SUS       11
#define JOS       12
#define FORMAT    13
#define LAT_LIT   14
#define INALT_LIT 15
#define KALCUL    16
#define SENS      17
#define FISIER    18
#define CUMULARE  19

uchar NUMEPROGRAM[]="WLST";
uchar font[]="Courier New";

void CALLBACK creare(void);
void calcul(uchar sw);

uchar nume_fis[13]="L.LST";
uchar nume_vec[13]="";
uchar nume_manp[]="MANEVP.MAN";
uchar nume_manr[]="MANEVR.MAN";
uchar nume_sens[]="SENS.FFF";
short nfsens;
struct PAGINI
{
   ulong  adresa;
   ulong  rand_inceput;
   ushort nr_randuri;
} artpg;
struct RANDURI
{
   ulong  adresa;
   ushort lungime;
} artrd;
ushort pagmax,rdmax;
short nf,nfp,nfr;
ulong RCSP,RCSR,nartp,nartr,RCS,lungime;

long FAR PASCAL _export WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);
void F_Print(HWND hwndmain);

ushort i,j,k,dela,pnla,lg;
ushort stg,drp,sus,jos,INALTIME,LATIME;
uchar pathd[60],k1,k2,sw,alfa[500];
#define NFER 29
HWND h[NFER];
HINSTANCE hInst;
ushort cx,cy;
LOGFONT lf;
PAINTSTRUCT ps;
HFONT hFont,hFont1;
PRINTDLG pd;
short xo,yo;
ushort inalt,lat,Inalt,Lat;
ushort lat_lit,inalt_lit;
DWORD HH;
uchar culoare,confirmare,orientare,sens,format;
uchar *culori[]=
{
   "NEAGRA",
   "ROSIE",
   "VERDE",
   "ALBASTRA",
};
uchar *fel[2]=
{
   "FARA",
   "CU"
};
int CULORI;
ulong adresa;
ulong HorSize,VerSize;
ushort pag;

int PASCAL WinMain(HANDLE hInstance,HANDLE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
   HWND hWnd;
   MSG msg;
   WNDCLASS wc;
   man[0]=lpCmdLine[0];
   man[0]=nCmdShow;
   if(!hPrevInstance)
   {
      wc.style=CS_HREDRAW|CS_VREDRAW;
      wc.lpfnWndProc=WndProc;
      wc.cbClsExtra=0;
      wc.cbWndExtra=0;
      wc.hInstance=hInstance;
      wc.hIcon=LoadIcon(NULL,IDI_APPLICATION);
      wc.hCursor=LoadCursor(NULL,IDC_ARROW);
      wc.hbrBackground=GetStockObject(WHITE_BRUSH);
      wc.lpszMenuName=NUMEPROGRAM;
      wc.lpszClassName=NUMEPROGRAM;
      RegisterClass(&wc);
   }
   hInst=hInstance;
   sprintf(pathd,"C:\\");
   pathd[0]='A'+getdisk();
   getcurdir(0,pathd+3);
   sprintf(pathd+strlen(pathd),"\\");
   hWnd=CreateWindow(NUMEPROGRAM,"LISTARE la IMPRIMANTA ing.Stan Sava, Buzau, Tel.0744/884449",WS_OVERLAPPEDWINDOW,
   CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,NULL,NULL,
   hInstance,NULL);
   ShowWindow(hWnd,SHOW_FULLSCREEN);
   UpdateWindow(hWnd);
   while(GetMessage(&msg,NULL,NULL,NULL))
   {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }
   return msg.wParam;
}

long FAR PASCAL _export WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
   HMENU hMenu;
   static DWORD wCurrentDC=LISTARE;
   switch(message)
   {
      case WM_CREATE:
         stg=15;
         drp=sus=jos=5;
         culoare=1;
         lat=210;
         inalt=297;
         lat_lit=0;
         inalt_lit=0;
         confirmare=1;
         orientare=sens=0;
         format=0; //A4
         INALTIME=LATIME=0xFFFF;
         nf=nfr=nfp=0;
         creare();
         h[0]=CreateWindow("edit",NULL,WS_CHILD|WS_VISIBLE|ES_CENTER|WS_BORDER,0,0,0,0,hWnd,FISIER,hInst,NULL);
         h[1]=CreateWindow("button","&NEGRU",WS_CHILD|WS_VISIBLE,0,0,0,0,hWnd,NEGRU,hInst,NULL);
         h[2]=CreateWindow("button","&ALBASTRU",WS_CHILD|WS_VISIBLE,0,0,0,0,hWnd,ALBASTRU,hInst,NULL);
         h[3]=CreateWindow("button","&VERDE",WS_CHILD|WS_VISIBLE,0,0,0,0,hWnd,VERDE,hInst,NULL);
         h[4]=CreateWindow("button","&ROSU",WS_CHILD|WS_VISIBLE,0,0,0,0,hWnd,ROSU,hInst,NULL);
         h[5]=CreateWindow("button",NULL,WS_CHILD|WS_VISIBLE,0,0,0,0,hWnd,LISTARE,hInst,NULL);
         h[6]=CreateWindow("button","&Terminare program",WS_CHILD|WS_VISIBLE|WS_SYSMENU,0,0,0,0,hWnd,TERMINARE,hInst,NULL);
         h[7]=CreateWindow("button","ing. Stan SAVA, Buzau, 04-iun-2005, Tel.0744/884449, email: bzsoft@zappmobile.ro",WS_CHILD|WS_VISIBLE|ES_LEFT|WS_BORDER,0,0,0,0,hWnd,NULL,hInst,NULL);
         h[8]=CreateWindow("button","Stanga (mm):",WS_CHILD|WS_VISIBLE|ES_CENTER|WS_BORDER,0,0,0,0,hWnd,NULL,hInst,NULL);
         h[9]=CreateWindow("button","Dreapta (mm):",WS_CHILD|WS_VISIBLE|ES_CENTER|WS_BORDER,0,0,0,0,hWnd,NULL,hInst,NULL);
         h[10]=CreateWindow("button","Sus (mm):",WS_CHILD|WS_VISIBLE|ES_CENTER|WS_BORDER,0,0,0,0,hWnd,NULL,hInst,NULL);
         h[11]=CreateWindow("button","Jos (mm):",WS_CHILD|WS_VISIBLE|ES_CENTER|WS_BORDER,0,0,0,0,hWnd,NULL,hInst,NULL);
         h[12]=CreateWindow("edit",NULL,WS_CHILD|WS_VISIBLE|ES_CENTER|WS_BORDER,0,0,0,0,hWnd,STANGA,hInst,NULL);
         h[13]=CreateWindow("edit",NULL,WS_CHILD|WS_VISIBLE|ES_CENTER|WS_BORDER,0,0,0,0,hWnd,DREAPTA,hInst,NULL);
         h[14]=CreateWindow("edit",NULL,WS_CHILD|WS_VISIBLE|ES_CENTER|WS_BORDER,0,0,0,0,hWnd,SUS,hInst,NULL);
         h[15]=CreateWindow("edit",NULL,WS_CHILD|WS_VISIBLE|ES_CENTER|WS_BORDER,0,0,0,0,hWnd,JOS,hInst,NULL);
         h[16]=CreateWindow("button",NULL,WS_CHILD|WS_VISIBLE|ES_CENTER|WS_BORDER,0,0,0,0,hWnd,FORMAT,hInst,NULL);
         h[17]=CreateWindow("button","Latime litera (mm):",WS_CHILD|WS_VISIBLE|ES_CENTER|WS_BORDER,0,0,0,0,hWnd,NULL,hInst,NULL);
         h[18]=CreateWindow("button","Inaltime litera (mm):",WS_CHILD|WS_VISIBLE|ES_CENTER|WS_BORDER,0,0,0,0,hWnd,NULL,hInst,NULL);
         h[19]=CreateWindow("edit",NULL,WS_CHILD|WS_VISIBLE|ES_CENTER|WS_BORDER,0,0,0,0,hWnd,LAT_LIT,hInst,NULL);
         h[20]=CreateWindow("edit",NULL,WS_CHILD|WS_VISIBLE|ES_CENTER|WS_BORDER,0,0,0,0,hWnd,INALT_LIT,hInst,NULL);
         h[21]=CreateWindow("button",NULL,WS_CHILD|WS_VISIBLE|ES_CENTER|WS_BORDER,0,0,0,0,hWnd,NULL,hInst,NULL);
         h[22]=CreateWindow("button",NULL,WS_CHILD|WS_VISIBLE|ES_CENTER|WS_BORDER,0,0,0,0,hWnd,NULL,hInst,NULL);
         h[23]=CreateWindow("button",NULL,WS_CHILD|WS_VISIBLE|ES_CENTER|WS_BORDER,0,0,0,0,hWnd,NULL,hInst,NULL);
         h[24]=CreateWindow("button",NULL,WS_CHILD|WS_VISIBLE,0,0,0,0,hWnd,STOP_PAG,hInst,NULL);
         h[25]=CreateWindow("button",NULL,WS_CHILD|WS_VISIBLE,0,0,0,0,hWnd,ORIENTARE,hInst,NULL);
         h[26]=CreateWindow("button","&Kalcul",WS_CHILD|WS_VISIBLE,0,0,0,0,hWnd,KALCUL,hInst,NULL);
         h[27]=CreateWindow("button",NULL,WS_CHILD|WS_VISIBLE,0,0,0,0,hWnd,SENS,hInst,NULL);
         h[28]=CreateWindow("button","C&Umulare",WS_CHILD|WS_VISIBLE,0,0,0,0,hWnd,CUMULARE,hInst,NULL);
         return 0;
      case WM_PAINT:
         BeginPaint(hWnd,&ps);
         EndPaint(hWnd,&ps);
         return 0;
      case WM_SIZE:
         cx=LOWORD(lParam);
         cy=HIWORD(lParam)/(NFER-19);
         SetFocus(h[5]);
         MoveWindow(h[0],0,0*cy,cx,cy,TRUE);
         MoveWindow(h[24],0,1*cy,cx/6,cy,TRUE);
         MoveWindow(h[25],cx/6,1*cy,cx/6,cy,TRUE);
         MoveWindow(h[1],2*cx/6,1*cy,cx/6,cy,TRUE);
         MoveWindow(h[2],3*cx/6,1*cy,cx/6,cy,TRUE);
         MoveWindow(h[3],4*cx/6,1*cy,cx/6,cy,TRUE);
         MoveWindow(h[4],5*cx/6,1*cy,cx/6,cy,TRUE);
         MoveWindow(h[8],0,2*cy,cx/8,cy,TRUE);
         MoveWindow(h[9],cx/4,2*cy,cx/8,cy,TRUE);
         MoveWindow(h[10],2*cx/4,2*cy,cx/8,cy,TRUE);
         MoveWindow(h[11],3*cx/4,2*cy,cx/8,cy,TRUE);
         MoveWindow(h[12],  cx/8,9*cy/4,cx/8,cy/2,TRUE);
         MoveWindow(h[13],3*cx/8,9*cy/4,cx/8,cy/2,TRUE);
         MoveWindow(h[14],5*cx/8,9*cy/4,cx/8,cy/2,TRUE);
         MoveWindow(h[15],7*cx/8,9*cy/4,cx/8,cy/2,TRUE);
         MoveWindow(h[16],0,3*cy,cx,cy,TRUE);
         MoveWindow(h[17],0,4*cy,cx/4,cy,TRUE);
         MoveWindow(h[18],cx/2,4*cy,cx/4,cy,TRUE);
         MoveWindow(h[19],cx/4,17*cy/4,cx/4,cy/2,TRUE);
         MoveWindow(h[20],3*cx/4,17*cy/4,cx/4,cy/2,TRUE);
         MoveWindow(h[21],0,5*cy,cx/3,cy,TRUE);
         MoveWindow(h[22],cx/3,5*cy,cx/3,cy,TRUE);
         MoveWindow(h[23],2*cx/3,5*cy,cx/3,cy,TRUE);
         MoveWindow(h[26],0,6*cy,cx/10,cy,TRUE);
         MoveWindow(h[27],cx/10,6*cy,cx/10,cy,TRUE);
         MoveWindow(h[28],2*cx/10,6*cy,cx/10,cy,TRUE);
         MoveWindow(h[5],3*cx/10,6*cy,7*cx/10,cy,TRUE);
         MoveWindow(h[6],0,7*cy,cx,cy,TRUE);
         MoveWindow(h[7],0,8*cy,cx,cy,TRUE);
         sprintf(man,"%s%s",pathd,nume_fis);
         SetWindowText(h[0],man);
         sprintf(man,"&O:");
         if(orientare) sprintf(man+strlen(man),"LANDSCAPE");else sprintf(man+strlen(man),"PORTRET");
         SetWindowText(h[25],man);
         sprintf(man,"&Listare la imprimanta A%u ",4-format);
         if(orientare) sprintf(man+strlen(man),"LANDSCAPE");else sprintf(man+strlen(man),"PORTRET");
         sprintf(man+strlen(man)," in culoarea %s %s confirmare pagina",culori[culoare-1],fel[confirmare]);
         SetWindowText(h[5],man);
         sprintf(man,"%u",stg);
         SetWindowText(h[12],man);
         sprintf(man,"%u",drp);
         SetWindowText(h[13],man);
         sprintf(man,"%u",sus);
         SetWindowText(h[14],man);
         sprintf(man,"%u",jos);
         SetWindowText(h[15],man);
         sprintf(man,"%u,%u",lat_lit/10,lat_lit%10);
         SetWindowText(h[19],man);
         sprintf(man,"%u,%u",inalt_lit/10,inalt_lit%10);
         SetWindowText(h[20],man);
         sprintf(man,"Pagina maxima:%u randuri",pagmax);
         SetWindowText(h[21],man);
         sprintf(man,"Randul maxim:%u caractere",rdmax);
         SetWindowText(h[22],man);
         sprintf(man,"Numar de pagini:%lu",nartp);
         SetWindowText(h[23],man);
         sprintf(man,"&Format:A%u  ( %u x %u mm )",4-format,lat,inalt);
         SetWindowText(h[16],man);
         sprintf(man,"&Confirmare:");
         if(confirmare) sprintf(man+strlen(man),"DA");else sprintf(man+strlen(man),"NU");
         SetWindowText(h[24],man);
         sprintf(man,"&Sens:");
         if(sens) sprintf(man+strlen(man),"DA");else sprintf(man+strlen(man),"NU");
         SetWindowText(h[27],man);
         return 0;
      case WM_COMMAND:
         switch(wParam)
         {
            case STOP_PAG:
               confirmare=1-confirmare;
               calcul(0);
               break;
            case KALCUL:
               calcul(1);
               break;
            case ORIENTARE:
               orientare=1-orientare;
               calcul(1);
               break;
            case SENS:
               sens=1-sens;
               nfsens=Open(pathd,nume_sens,FA_ARCH);
               if(nfsens)
               {
                  man[0]=sens;
                  WRITEF(nfsens,man,1l);
                  CLOSE(nfsens);
               }
               calcul(0);
               break;
            case NEGRU:
               culoare=1;
               calcul(0);
               break;
            case ALBASTRU:
               culoare=4;
               calcul(0);
               break;
            case VERDE:
               culoare=3;
               calcul(0);
               break;
            case ROSU:
               culoare=2;
               calcul(0);
               break;
            case STANGA:
               GetWindowText(h[12],man,5);
               stg=atol(man);
               break;
            case DREAPTA:
               GetWindowText(h[13],man,5);
               drp=atol(man);
               break;
            case SUS:
               GetWindowText(h[14],man,5);
               sus=atol(man);
               break;
            case JOS:
               GetWindowText(h[15],man,5);
               jos=atol(man);
               break;
            case FORMAT:
               format=1-format;
               if(!format)
               {
                  lat=210;
                  inalt=297;
               }
               else
               {
                  lat=420;
                  inalt=297;
               }
               calcul(1);
               break;
            case LAT_LIT:
               GetWindowText(h[19],man,6);
               lat_lit=0;
               i=k=0;
               for(j=0;j<strlen(man);j++)
               {
                  if(man[j]=='.'||man[j]==',')
                  {
                     k++;
                     if(k>1) break;
                     i=0;
                     continue;
                  }
                  if(k)
                  {
                     i++;
                     if(i>1) break;
                  }
                  if(!isdigit(man[j])) continue;
                  lat_lit*=10;
                  lat_lit+=man[j]-'0';
               }
               if(!k) lat_lit*=10;
               break;
            case INALT_LIT:
               GetWindowText(h[20],man,6);
               inalt_lit=0;
               i=k=0;
               for(j=0;j<strlen(man);j++)
               {
                  if(man[j]=='.'||man[j]==',')
                  {
                     k++;
                     if(k>1) break;
                     i=0;
                     continue;
                  }
                  if(k)
                  {
                     i++;
                     if(i>1) break;
                  }
                  if(!isdigit(man[j])) continue;
                  inalt_lit*=10;
                  inalt_lit+=man[j]-'0';
               }
               if(!k) inalt_lit*=10;
               break;
            case FISIER:
               memset(man,0,1024);
               GetWindowText(h[0],man,70);
               k1=strlen(man);
               k2=sprintf(alfa,"%s%s",pathd,nume_fis);
               k=k1;if(k2>k) k=k2;
               if(!strnicmp(man+k1-4,".LST",4)&&strnicmp(man,alfa,k2))
               {
                  memset(pathd,0,60);
                  memset(nume_fis,0,13);
                  j=k=0;
                  k1=strlen(man);
                  while(k1)
                  {
                     if(man[k1-1]!=0x0D&&man[k1-1]!=0x0A) break;
                     k1--;
                  }
                  for(k2=k1;k2;k2--) if(man[k2]=='\\') break;
                  for(i=0;i<=k2;i++)
                  {
                     if(man[i]==' ') continue;
                     pathd[j++]=man[i];
                     if(j>=59) break;
                  }
                  for(i=k2+1;i<k1;i++)
                  {
                     if(man[i]==' ') continue;
                     nume_fis[k++]=man[i];
                     if(k>=12) break;
                  }
                  creare();
                  calcul(1);
               }
               break;
            case LISTARE:
               if(stg+drp>=0.9*lat)
               {
                  MessageBox(hWnd,"Margine STANGA sau DREAPTA prea mare !",NUMEPROGRAM,MB_OK);
                  break;
               }
               if(sus+jos>=0.9*inalt)
               {
                  MessageBox(hWnd,"Margine SUS sau JOS prea mare !",NUMEPROGRAM,MB_OK);
                  break;
               }
               if(lat_lit<3)
               {
                  MessageBox(hWnd,"Latime litera prea mica !",NUMEPROGRAM,MB_OK);
                  break;
               }
               if(inalt_lit<3)
               {
                  MessageBox(hWnd,"Inaltime litera prea mica !",NUMEPROGRAM,MB_OK);
                  break;
               }
               F_Print(hWnd);
               break;
            case TERMINARE:
               SendMessage(hWnd,WM_CLOSE,0,0l);
               break;
         }
         if(wParam==wCurrentDC) return 0;
         hMenu=GetMenu(hWnd);
         CheckMenuItem(hMenu,wCurrentDC,MF_UNCHECKED);
         CheckMenuItem(hMenu,wCurrentDC=wParam,MF_CHECKED);
         return 0;
      case WM_CLOSE:
         DestroyWindow(hWnd);
         return 0;
      case WM_DESTROY:
         PostQuitMessage(0);
         return 0;
   }
   return DefWindowProc(hWnd,message,wParam,lParam);
}

void F_Print(HWND hwndmain)
{
   if(!nartp) return;
   memset(&pd,0,sizeof(PRINTDLG));
   pd.lStructSize=sizeof(PRINTDLG);
   pd.hwndOwner=hwndmain;
   pd.Flags=PD_RETURNDC;
   pd.nMinPage=1;
   pd.nMaxPage=nartp;
   pd.nFromPage=1;
   pd.nToPage=nartp;
   pd.nCopies=1;
   if(!PrintDlg(&pd)) return;
   HorSize=GetDeviceCaps(pd.hDC,HORZSIZE);
   VerSize=GetDeviceCaps(pd.hDC,VERTSIZE);
   Lat=HorSize;
   Inalt=VerSize;
   // Stabilesc eu sensul
   i=GetDeviceCaps(pd.hDC,TEXTCAPS)&TC_CR_90;
   if(i) sens=1;else sens=0;
   //
   if(format)
   {
      if(Lat<400)
      {
         MessageBox(hwndmain,"Imprimanta este setata pe un format de hartie mai mic",NUMEPROGRAM,MB_OK);
         goto gata;
      }
   }
   if(!orientare)
   {
      xo=stg*10;
      yo=-sus*10;
   }
   else
   {
      xo=sus*10;
      yo=-(inalt-stg)*10;
   }
   dela=pd.nFromPage;
   pnla=pd.nToPage;
   for(pag=pd.nFromPage;pag<=pd.nToPage;pag++)
   {
      if(confirmare)
      {
         sprintf(man,"Pagina %u listati ?",pag);
         i=MessageBox(hwndmain,man,NUMEPROGRAM,MB_OKCANCEL);
         if(i==2) break;
      }
      j=sprintf(man,"%s Pag:%u",NUMEPROGRAM,pag);
      Escape(pd.hDC,STARTDOC,j,man,NULL);
      SetBkMode(pd.hDC,TRANSPARENT);
      man[0]=man[1]=man[2]=man[3]=0;man[culoare-1]=0xFF;
      CULORI=RGB(man[1],man[2],man[3]);
      SetTextColor(pd.hDC,CULORI);
      SetMapMode(pd.hDC,MM_LOMETRIC);
      SetTextAlign(pd.hDC,TA_LEFT);
      LSEEK(nfp,(pag-1)*RCSP,SEEK_SET);
      READF(nfp,&artpg,RCSP);
      LSEEK(nfr,artpg.rand_inceput*RCSR,SEEK_SET);
      for(i=0;i<artpg.nr_randuri;i++)
      {
         READF(nfr,&artrd,RCSR);
         LSEEK(nf,artrd.adresa,SEEK_SET);
         READF(nf,man,(ulong)artrd.lungime);
         memset(&lf,0,sizeof(lf));
         lf.lfWeight=100;
         lf.lfHeight=inalt_lit;
         lf.lfWidth=lat_lit;
         lf.lfCharSet=OEM_CHARSET;
         lf.lfOutPrecision=OUT_DEFAULT_PRECIS;
         lf.lfClipPrecision=CLIP_CHARACTER_PRECIS;
         lf.lfQuality=DRAFT_QUALITY;
         lf.lfPitchAndFamily=FIXED_PITCH|FF_MODERN;
         if(!orientare)
         {
            lf.lfOrientation=0;
            lf.lfEscapement=0;
         }
         else
         {
            if(!sens)
            {
               lf.lfEscapement=2700;
               lf.lfOrientation=2700;
            }
            else
            {
               lf.lfEscapement=900;
               lf.lfOrientation=900;
            }
         }
         lstrcpy(lf.lfFaceName,font);
         hFont1=CreateFontIndirect(&lf);
         hFont=SelectObject(pd.hDC,hFont1);
         for(j=artrd.lungime;j;j--)
         {
            if(man[j-1]==0x0D||man[j-1]==0x0A||man[j-1]==' ') continue;
            break;
         }
         man[j]='\0';
         if(j)
         {
            if(!orientare) TextOut(pd.hDC,xo,yo-i*inalt_lit,man,j);
            else TextOut(pd.hDC,xo+i*inalt_lit,yo,man,j);
         }
         DeleteObject(SelectObject(pd.hDC,hFont));
      }
      Escape(pd.hDC,NEWFRAME,0,NULL,NULL);
      Escape(pd.hDC,ENDDOC,0,NULL,NULL);
   }
gata:
   DeleteDC(pd.hDC);
   if(pd.hDevMode) GlobalFree(pd.hDevMode);
   if(pd.hDevNames) GlobalFree(pd.hDevNames);
}

void CALLBACK creare(void)
{
   if(nfr) CLOSE(nfr);
   if(nfp) CLOSE(nfp);
   if(nf) CLOSE(nf);
   nfr=nfp=nf=0;
   sprintf(man,"%s%s",pathd,nume_fis);
   if(access(man,0)) return;
   nartp=nartr=0;
   pagmax=rdmax=0;
   RCSP=sizeof(artpg);
   RCSR=sizeof(artrd);
   RCS=1024;
   sprintf(man,"%s%s",pathd,nume_sens);
   if(!access(man,0))
   {
      nfsens=Open(pathd,nume_sens,O_BINARY|O_RDONLY);
      if(nfsens<1) return;
      lungime=filelength(nfsens);
      if(lungime)
      {
         READF(nfsens,man,1l);
         sens=man[0];
      }
      CLOSE(nfsens);
   }
   nf=Open(pathd,nume_fis,O_BINARY|O_RDONLY);
   if(nf<1) return;
   lungime=filelength(nf);
   if(!lungime)
   {
      CLOSE(nf);
      nf=0;
      return;
   }
   nfp=OPEN(nume_manp,FA_ARCH);
   if(nfp<1)
   {
      CLOSE(nf);
      nf=0;
      return;
   }
   nfr=OPEN(nume_manr,FA_ARCH);
   if(nfr<1)
   {
      CLOSE(nf);
      CLOSE(nfp);
      nf=nfp=0;
      return;
   }
   memset(&artpg,0,(int)RCSP);
   memset(&artrd,0,(int)RCSR);
   adresa=0;
   sw=0;
   while(lungime)
   {
      if(lungime<RCS) RCS=lungime;
      READF(nf,man,RCS);
      lungime-=RCS;
      if(!strncmp(man,"Set_Sava_Stan:",14))
      {
         j=13;
         k=0;
         memset(alfa,'\0',20);
         while(1)
         {
            j++;
            if(isdigit(man[j])||man[j]=='.')
            {
               alfa[k++]=man[j];
               continue;
            }
            break;
         }
         INALTIME=floor(1e1*atof(alfa)+0.5);
         k=0;
         memset(alfa,'\0',20);
         while(1)
         {
            j++;
            if(isdigit(man[j])||man[j]=='.')
            {
               alfa[k++]=man[j];
               continue;
            }
            break;
         }
         LATIME=floor(1e1*atof(alfa)+0.5);
         continue;
      }
      for(j=0;j<RCS;j++)
      {
         if(man[j]==0x0D) continue;
         if(man[j]==0x0C) //pagina noua
         {
            artpg.nr_randuri++;
            WRITEF(nfp,&artpg,RCSP);
            nartp++;
            WRITEF(nfr,&artrd,RCSR);
            nartr++;
            artpg.adresa=adresa+j+3;
            artpg.nr_randuri=0;
            artpg.rand_inceput=nartr;
            artrd.lungime=0;
            artrd.adresa=adresa+j+3;
            sw=1;
         }
         else
         {
            if(man[j]==0x0A)
            {
               if(!sw)
               {
                  WRITEF(nfr,&artrd,RCSR);
                  nartr++;
                  artpg.nr_randuri++;
               }
               else sw=0;
               artrd.adresa=adresa+j+1;
               artrd.lungime=0;
            }
            else
            {
               artrd.lungime++;
            }
         }
      }
      adresa+=RCS;
   }
   if(artrd.lungime)
   {
      WRITEF(nfr,&artrd,RCSR);
      nartr++;
      artpg.nr_randuri++;
   }
   if(artpg.nr_randuri)
   {
      WRITEF(nfp,&artpg,RCSP);
      nartp++;
   }
   for(pag=0;pag<nartp;pag++)
   {
      LSEEK(nfp,pag*RCSP,SEEK_SET);
      READF(nfp,&artpg,RCSP);
      if(artpg.nr_randuri>pagmax) pagmax=artpg.nr_randuri;
      LSEEK(nfr,artpg.rand_inceput*RCSR,SEEK_SET);
      for(i=0;i<artpg.nr_randuri;i++)
      {
         READF(nfr,&artrd,RCSR);
         LSEEK(nf,artrd.adresa,SEEK_SET);
         READF(nf,man,(ulong)artrd.lungime);
         for(j=artrd.lungime;j;j--)
         {
            if(man[j-1]==0x0D||man[j-1]==0x0A||man[j-1]==' ') continue;
            break;
         }
         if(j>rdmax) rdmax=j;
      }
   }
   if(pagmax&&rdmax)
   {
      if(!orientare)
      {
         inalt_lit=floor(96e-1*(inalt-sus-jos)/pagmax);
         lat_lit=floor(96e-1*(lat-stg-drp)/rdmax);
      }
      else
      {
         inalt_lit=floor(96e-1*(lat-sus-jos)/pagmax);
         lat_lit=(96e-1*(inalt-stg-drp)/rdmax);
      }
   }
   if(inalt_lit>40) inalt_lit=40;
   if(lat_lit>20) lat_lit=20;
   if(INALTIME!=0xFFFF) inalt_lit=INALTIME;
   if(LATIME!=0xFFFF) lat_lit=LATIME;
}

void calcul(uchar Sw)
{
   sprintf(man,"&O:");
   if(orientare) sprintf(man+strlen(man),"LANDSCAPE");else sprintf(man+strlen(man),"PORTRET");
   SetWindowText(h[25],man);
   sprintf(man,"&Listare la imprimanta A%u ",4-format);
   if(orientare) sprintf(man+strlen(man),"LANDSCAPE");else sprintf(man+strlen(man),"PORTRET");
   sprintf(man+strlen(man)," in culoarea %s %s confirmare pagina",culori[culoare-1],fel[confirmare]);
   SetWindowText(h[5],man);
   if(pagmax&&rdmax&&Sw)
   {
      if(!orientare)
      {
         inalt_lit=floor(96e-1*(inalt-sus-jos)/pagmax);
         lat_lit=floor(96e-1*(lat-stg-drp)/rdmax);
      }
      else
      {
         inalt_lit=floor(96e-1*(lat-sus-jos)/pagmax);
         lat_lit=(96e-1*(inalt-stg-drp)/rdmax);
      }
   }
   if(inalt_lit>40) inalt_lit=40;
   if(lat_lit>20) lat_lit=20;
   sprintf(man,"%u",stg);
   SetWindowText(h[12],man);
   sprintf(man,"%u",drp);
   SetWindowText(h[13],man);
   sprintf(man,"%u",sus);
   SetWindowText(h[14],man);
   sprintf(man,"%u",jos);
   SetWindowText(h[15],man);
   sprintf(man,"%u,%u",lat_lit/10,lat_lit%10);
   SetWindowText(h[19],man);
   sprintf(man,"%u,%u",inalt_lit/10,inalt_lit%10);
   SetWindowText(h[20],man);
   sprintf(man,"Pagina maxima:%u randuri",pagmax);
   SetWindowText(h[21],man);
   sprintf(man,"Randul maxim:%u caractere",rdmax);
   SetWindowText(h[22],man);
   sprintf(man,"Numar de pagini:%lu",nartp);
   SetWindowText(h[23],man);
   sprintf(man,"&Format:A%u  ( %u x %u mm )",4-format,lat,inalt);
   SetWindowText(h[16],man);
   sprintf(man,"&Confirmare:");
   if(confirmare) sprintf(man+strlen(man),"DA");else sprintf(man+strlen(man),"NU");
   SetWindowText(h[24],man);
   sprintf(man,"&Sens:");
   if(sens) sprintf(man+strlen(man),"DA");else sprintf(man+strlen(man),"NU");
   SetWindowText(h[27],man);
}
