#include <dos.h>
#include <io.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <stat.h>
#include <math.h>

typedef unsigned short ushort;
typedef unsigned long  ulong;
typedef unsigned char  uchar;

uchar nume_dbf[]="EXEMPLU.DBF";
short nf;
ulong nart;
ushort RCS;
#define NR_CAMPURI 11
struct BAZA
{
   uchar den_camp[11];
   uchar tip_camp;
   uchar lg_camp;
   uchar nr_zec;
} strbaza[NR_CAMPURI]=
{
   "UNITATE"    ,'N', 4,0,
   "DEN_UNIT"   ,'C',40,0,
   "COD_LOCM"   ,'N', 4,0,
   "DEN_LOCM"   ,'C',24,0,
   "COD_FUNC"   ,'N', 4,0,
   "DEN_FUNC"   ,'C',24,0,
   "MARCA"      ,'N', 8,0,
   "NUME"       ,'C',24,0,
   "SALARIUL"   ,'N',14,3,
   "IMPOZITUL"  ,'N',14,3,
   "REST_PLATA" ,'N',14,3
};
struct ANTET_BAZA
{
   uchar  versiune;
   uchar  anul;
   uchar  luna;
   uchar  ziua;
   ulong  nr_art;
   ushort lg_antet;
   ushort RCS;
   uchar  zero[20];
   struct
   {
      uchar den_camp[11];
      uchar tip_camp;
      ulong adresa;
      uchar lg_camp;
      uchar nr_zec;
      uchar zero[14];
   } campuri[NR_CAMPURI];
} aa;
uchar dbf[2048];
uchar man[100];
struct date d;
ushort i;
ulong salariul,impozit,restul,nr_inreg;

void main(void)
{
   getdate(&d);
   aa.versiune=3;
   aa.anul=d.da_year-1900;
   aa.luna=d.da_mon;
   aa.ziua=d.da_day;
   aa.nr_art=0;
   aa.lg_antet=0;
   aa.RCS=1;
   memset(aa.zero,'\0',20);
   for(i=0;i<NR_CAMPURI;i++)
   {
      strncpy(aa.campuri[i].den_camp,strbaza[i].den_camp,11);
      aa.campuri[i].tip_camp=strbaza[i].tip_camp;
      aa.campuri[i].adresa=aa.RCS;
      aa.campuri[i].lg_camp=strbaza[i].lg_camp;
      aa.campuri[i].nr_zec=strbaza[i].nr_zec;
      memset(aa.campuri[i].zero,'\0',14);
      aa.RCS+=aa.campuri[i].lg_camp;
   }
   RCS=aa.RCS;
   aa.lg_antet=(NR_CAMPURI+1)*32+1;
   if((nf=open(nume_dbf,O_CREAT|O_BINARY|O_TRUNC|O_RDWR,S_IWRITE|S_IREAD))<1)
   {
      printf("\nNu pot crea fisierul %s.",nume_dbf);
      return;
   }
   RCS=aa.lg_antet;
   write(nf,&aa,RCS-1);
   man[0]=0x0D;
   write(nf,man,1);
   RCS=aa.RCS;
   salariul=1000000;
   nr_inreg=0;
   for(i=0;i<1234;i++)
   {
      memset(&dbf,' ',aa.RCS);
      sprintf(man,"%04u",i+1);
      strncpy(dbf+aa.campuri[0].adresa,man,4);
      sprintf(man,"Unitatea numarul %u%40s",i+1,"");
      strncpy(dbf+aa.campuri[1].adresa,man,40);
      sprintf(man,"%04u",i+11);
      strncpy(dbf+aa.campuri[2].adresa,man,4);
      sprintf(man,"Locul de munca numarul %u%24s",i+11,"");
      strncpy(dbf+aa.campuri[3].adresa,man,24);
      sprintf(man,"%04u",i+101);
      strncpy(dbf+aa.campuri[4].adresa,man,4);
      sprintf(man,"Functia numarul %u%24s",i+101,"");
      strncpy(dbf+aa.campuri[5].adresa,man,24);
      sprintf(man,"%04u",i+1001);
      strncpy(dbf+aa.campuri[6].adresa,man,4);
      sprintf(man,"Salariatul cu marca %u%24s",i+1001,"");
      strncpy(dbf+aa.campuri[7].adresa,man,24);
      sprintf(man,"%14.3f",1e-3*salariul);
      strncpy(dbf+aa.campuri[8].adresa,man,14);
      impozit=floor(16e-2*salariul+0.5);
      sprintf(man,"%14.3f",1e-3*impozit);
      strncpy(dbf+aa.campuri[9].adresa,man,14);
      restul=salariul-impozit;
      sprintf(man,"%14.3f",1e-3*restul);
      strncpy(dbf+aa.campuri[10].adresa,man,14);
      write(nf,&dbf,RCS);
      salariul+=1234;
      nr_inreg++;
   }
   man[0]=0x1A;
   write(nf,man,1);
   lseek(nf,4l,SEEK_SET);
   write(nf,&nr_inreg,4l);
   close(nf);
}